IF EXISTS (SELECT * FROM SYS.triggers WHERE NAME = 'TRG_EST_SNGPC_ENTRADA_ESTOQUE_INSERT') 
BEGIN
	DROP TRIGGER TRG_EST_SNGPC_ENTRADA_ESTOQUE_INSERT
END



SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER dbo.TRG_EST_SNGPC_ENTRADA_ESTOQUE_INSERT ON dbo.EST_SNGPC_ENTRADA
WITH EXECUTE AS CALLER
FOR INSERT
AS
BEGIN
	-- DECLARAO DAS VARIVEIS
	DECLARE @CD_ENT      INT;
	DECLARE @CD_MOV_ANT  INT;
	DECLARE @CD_MOV_POS  INT;
	DECLARE @CD_EMP      INT;
	DECLARE @CD_FILIAL   INT;
	DECLARE @CD_PROD     INT;
	DECLARE @DT_MOV      DATETIME;
	DECLARE @DT_REINICIO DATETIME;
	DECLARE @QT_LOTE     INT;

	-- DEFINIO DAS VARIVEIS
	SELECT
		@CD_ENT      = I.CD_ENT_SNGPC
		, @CD_EMP    = I.CD_EMP
		, @CD_FILIAL = I.CD_FILIAL
		, @CD_PROD   = I.CD_PROD
		, @DT_MOV    = I.DT_MOV
		, @QT_LOTE   = I.QT_LOTE
	FROM
		INSERTED I;

	-- SELECIONA A DATA DE REINCIO DO INVENTRIO
	SELECT
		TOP 1
		@DT_REINICIO = DT_REINICIO
	FROM
		EST_SNGPC_REINICIO_INVENTARIO (NOLOCK)
	WHERE
		CD_EMP        = @CD_EMP
		AND CD_FILIAL = @CD_FILIAL
	ORDER BY
		CD_REINICIO DESC;

	IF @DT_REINICIO IS NULL
		SET @DT_REINICIO = '1900-01-01';

	-- SELECIONA A MOVIMENTAO ANTERIOR
	SELECT 
		TOP 1
		@CD_MOV_ANT = CD_MOV
	FROM
		EST_SNGPC_ENT_SAI (NOLOCK)
	WHERE
		CD_EMP        = @CD_EMP
		AND CD_FILIAL = @CD_FILIAL
		AND CD_PROD   = @CD_PROD
		AND (DT_MOV < @DT_MOV OR DT_MOV = @DT_MOV)
		AND DT_MOV    > @DT_REINICIO
	ORDER BY
		DT_MOV DESC
		, CD_MOV DESC;

	-- SELECIONAR A MOVIMENTAO POSTERIOR
	SELECT 
		TOP 1
		@CD_MOV_POS = CD_MOV
	FROM
		EST_SNGPC_ENT_SAI (NOLOCK)
	WHERE
		CD_EMP        = @CD_EMP
		AND CD_FILIAL = @CD_FILIAL
		AND CD_PROD   = @CD_PROD
		AND (DT_MOV > @DT_MOV OR DT_MOV = @DT_MOV)
		AND DT_MOV    > @DT_REINICIO
	ORDER BY
		DT_MOV
		, CD_MOV;


	/******************************************************************/
	/* PROCESSO PARA INSERO DO REGISTRO NA TABELA EST_SNGPC_ENT_SAI */
	/******************************************************************/

	-- VERIFICA SE EXISTE MOVIMENTAO ANTERIOR
	IF @CD_MOV_ANT IS NULL
		-- SE NO EXISTIR MOVIMENTAO ANTERIOR
		BEGIN
			-- VERIFICA SE EXISTE MOVIMENTAO POSTERIOR
			IF @CD_MOV_POS IS NULL
				-- SE NO EXISTIR MOVIMENTAO POSTERIOR
				BEGIN
					-- INSERE O REGISTRO PEGANDO O ESTOQUE DA EST_PROD_EST_SNGPC_LOTE_CPL
					INSERT INTO EST_SNGPC_ENT_SAI (CD_ENT_SNGPC, CD_EMP, CD_FILIAL, CD_PROD, DT_MOV, QT_FINAL)
					SELECT
						ENT.CD_ENT_SNGPC
						, ENT.CD_EMP
						, ENT.CD_FILIAL
						, ENT.CD_PROD
						, ENT.DT_MOV
						, COALESCE(QTD.QT_LOTE, 0) + @QT_LOTE
					FROM
						EST_SNGPC_ENTRADA (NOLOCK) AS ENT
						LEFT JOIN (
							SELECT
								CPL.CD_EMP
								, CPL.CD_FILIAL
								, LOT.CD_PROD
								, SUM(CPL.QT_LOTE) AS QT_LOTE
							FROM
								EST_PROD_EST_SNGPC_LOTE (NOLOCK) AS LOT
								INNER JOIN EST_PROD_EST_SNGPC_LOTE_CPL (NOLOCK) AS CPL ON
									LOT.CD_LOTE = CPL.CD_LOTE
							WHERE
								CPL.CD_EMP        = @CD_EMP
								AND CPL.CD_FILIAL = @CD_FILIAL
								AND LOT.CD_PROD   = @CD_PROD
							GROUP BY
								CPL.CD_EMP
								, CPL.CD_FILIAL
								, LOT.CD_PROD	
						) AS QTD ON
							ENT.CD_EMP        = QTD.CD_EMP
							AND ENT.CD_FILIAL = QTD.CD_FILIAL
							AND ENT.CD_PROD   = QTD.CD_PROD
					WHERE
						ENT.CD_ENT_SNGPC = @CD_ENT;
				
				END
			ELSE
				-- SE EXISTIR MOVIMENTAO POSTERIOR
				BEGIN
					-- INSERE O REGISTRO PEGANDO O ESTOQUE DA MOVIMENTAO POSTERIOR
					INSERT INTO EST_SNGPC_ENT_SAI (CD_ENT_SNGPC, CD_EMP, CD_FILIAL, CD_PROD, DT_MOV, QT_FINAL)
					SELECT
						@CD_ENT
						, @CD_EMP
						, @CD_FILIAL
						, @CD_PROD
						, @DT_MOV
						, (
							CASE
								WHEN A.CD_ENT_SNGPC IS NOT NULL THEN
									(A.QT_FINAL - B.QT_LOTE) + @QT_LOTE
								ELSE
									(A.QT_FINAL + C.QT_LOTE) + @QT_LOTE
							END
						)
					FROM
						EST_SNGPC_ENT_SAI (NOLOCK) A
						LEFT JOIN EST_SNGPC_ENTRADA (NOLOCK) B ON
							A.CD_ENT_SNGPC = B.CD_ENT_SNGPC
						LEFT JOIN EST_SNGPC_SAIDA (NOLOCK) C ON
							A.CD_SAI_SNGPC = C.CD_SAI_SNGPC
					WHERE
						A.CD_MOV = @CD_MOV_POS;

				END;
		END
	ELSE
		-- SE EXISTE MOVIMENTAO ANTERIOR
		BEGIN
			-- INSERE O REGISTRO PEGANDO O ESTOQUE DA MOVIMENTAO ANTERIOR
			INSERT INTO EST_SNGPC_ENT_SAI (CD_ENT_SNGPC, CD_EMP, CD_FILIAL, CD_PROD, DT_MOV, QT_FINAL)
			SELECT
				@CD_ENT
				, @CD_EMP
				, @CD_FILIAL
				, @CD_PROD
				, @DT_MOV
				, QT_FINAL + @QT_LOTE
			FROM
				EST_SNGPC_ENT_SAI (NOLOCK)
			WHERE
				CD_MOV = @CD_MOV_ANT;
		END;

	/**********************************************/
	/* PROCESSO PARA ATUALIZAO DO ESTOQUE FINAL */
	/* DOS REGISTROS NA TABELA EST_SNGPC_ENT_SAI  */
	/**********************************************/

	-- ATUALIZA O ESTOQUE DE TODAS AS MOVIMENTAES POSTERIORES
	UPDATE
		EST_SNGPC_ENT_SAI
	SET
		QT_FINAL = QT_FINAL + @QT_LOTE
	WHERE
		CD_EMP        = @CD_EMP
		AND CD_FILIAL = @CD_FILIAL
		AND CD_PROD   = @CD_PROD
		AND DT_MOV    > @DT_MOV
		AND DT_MOV    > @DT_REINICIO;
END
GO